local t = Def.ActorFrame {};

local function bannerframeDisplay(pos_Y)
	return Def.ActorFrame{
		LoadActor(THEME:GetPathB("ScreenEvaluationSummary","bannerframe"))..{
		InitCommand=cmd(x,SCREEN_CENTER_X;y,pos_Y);
		OffCommand=cmd(linear,0.17;zoomx,0;diffusealpha,0);
	}
}
end




local function finAwardDisplay(pn, sAward, pos_Y)
	return Def.Sprite{
		InitCommand = function(self)
			if(sAward == 'StageAward_SingleDigitW3' or sAward == 'StageAward_OneW3' or sAward == 'StageAward_FullComboW3') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Fullcombo_ring"));
			elseif(sAward == 'StageAward_SingleDigitW2' or sAward == 'StageAward_OneW2' or sAward == 'StageAward_FullComboW2') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","PerfectFullcombo_ring"));
			elseif(sAward == 'StageAward_FullComboW1') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","MarvelousFullcombo_ring"));
			end;
			
			if(pn=="PL1") then
				self:player('PlayerNumber_P1');
				self:x(SCREEN_CENTER_X-82);
			else
				self:player('PlayerNumber_P2');
				self:x(SCREEN_CENTER_X+107);
			end
			
			self:y(pos_Y-5);
		end;
		OnCommand=cmd(zoom,0;diffusealpha,0;sleep,0.1;linear,0.2;zoom,0.26;diffusealpha,1;glowshift;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.15");effectperiod,0.2;spin;effectmagnitude,0,0,170);
		OffCommand=cmd(linear,0.2;zoom,0;diffusealpha,0);

	}

end





local function finGradeDisplay(pn, sGrade, pos_Y)
	return Def.Sprite{
		InitCommand = function(self)
			if(sGrade == 'Grade_Tier01') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_Omega"));
			elseif(sGrade == 'Grade_Tier02') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_3AP"));
			elseif(sGrade == 'Grade_Tier03') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_3A.png"));
			elseif(sGrade == 'Grade_Tier04') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_3AM"));
			elseif(sGrade == 'Grade_Tier05') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_2AP"));
			elseif(sGrade == 'Grade_Tier06') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_2A.png"));
			elseif(sGrade == 'Grade_Tier07') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_2AM"));
			elseif(sGrade == 'Grade_Tier08') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_AP"));
			elseif(sGrade == 'Grade_Tier09') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_A.png"));
			elseif(sGrade == 'Grade_Tier10') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_AM"));
			elseif(sGrade == 'Grade_Tier11') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_BP"));
			elseif(sGrade == 'Grade_Tier12') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_B.png"));
			elseif(sGrade == 'Grade_Tier13') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_BM"));
			elseif(sGrade == 'Grade_Tier14') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_CP"));
			elseif(sGrade == 'Grade_Tier15') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_C.png"));
			elseif(sGrade == 'Grade_Tier16') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_CM"));
			elseif(sGrade == 'Grade_Tier17') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_D"));
			elseif(sGrade == 'Grade_Failed') then
				self:Load(THEME:GetPathB("ScreenEvaluationSummary","Grade_E"));
			end;
			
			if(pn=="PL1") then
				self:player('PlayerNumber_P1');
				self:x(SCREEN_CENTER_X-93);
			else
				self:player('PlayerNumber_P2');
				self:x(SCREEN_CENTER_X+93);
			end
			
			self:y(pos_Y);
		end;
		OnCommand=cmd(zoomy,0;zoomx,0.27;diffusealpha,0;sleep,0.1;linear,0.2;zoomy,0.27;diffusealpha,1;glowshift;effectcolor1,color("1,1,1,0");effectcolor2,color("1,1,1,0.15");effectperiod,0.2;);
		OffCommand=cmd(linear,0.2;zoomy,0;diffusealpha,0);

	}

end

local function StagePanelDisplay(pn, pos_Y)
	return Def.Sprite{
		InitCommand = function(self)
			self:Load(THEME:GetPathB("ScreenEvaluationSummary","stagepanel"));

			if(pn=="PL1") then
				self:player('PlayerNumber_P1');
				self:x(SCREEN_CENTER_X-175);
			else
				self:player('PlayerNumber_P2');
				self:x(SCREEN_CENTER_X+175);
				self:rotationy(180);
			end
			
			self:y(pos_Y);
		end;
		OnCommand=cmd(zoomy,0;zoomx,1;diffusealpha,0;sleep,0.1;linear,0.2;zoomy,1;diffusealpha,1);
		OffCommand=cmd(linear,0.2;zoomy,0;diffusealpha,0);

	}

end



--.back1


t[#t+1] = Def.Sprite{
	InitCommand = function(self)
		self:Load(THEME:GetPathB("ScreenEvaluationSummary","back1"));
	end;
	OnCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoomy,0;diffusealpha,0;sleep,0.1,linear,0.2;zoomy,1;diffusealpha,0.8);
	OffCommand=cmd(linear,0.25;diffusealpha,0;zoomy,0);
}

--BannerFrame
if STATSMAN:GetStagesPlayed()==1 then
	t[#t+1] = bannerframeDisplay(240);
	
elseif STATSMAN:GetStagesPlayed() == 2 then
	t[#t+1] = bannerframeDisplay(240+30);
	t[#t+1] = bannerframeDisplay(240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	t[#t+1] = bannerframeDisplay(240+60);
	t[#t+1] = bannerframeDisplay(240+0);
	t[#t+1] = bannerframeDisplay(240-60);
	
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = bannerframeDisplay(240+60);
		t[#t+1] = bannerframeDisplay(240+0);
		t[#t+1] = bannerframeDisplay(240-60);
	else 
		t[#t+1] = bannerframeDisplay(240+90);
		t[#t+1] = bannerframeDisplay(240+30);
		t[#t+1] = bannerframeDisplay(240-30);
		t[#t+1] = bannerframeDisplay(240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = bannerframeDisplay(240+60);
		t[#t+1] = bannerframeDisplay(240+0);
		t[#t+1] = bannerframeDisplay(240-60);
	elseif GAMESTATE:IsExtraStage()  then
		t[#t+1] = bannerframeDisplay(240+90);
		t[#t+1] = bannerframeDisplay(240+30);
		t[#t+1] = bannerframeDisplay(240-30);
		t[#t+1] = bannerframeDisplay(240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		t[#t+1] = bannerframeDisplay(240+120);
		t[#t+1] = bannerframeDisplay(240+60);
		t[#t+1] = bannerframeDisplay(240+0);
		t[#t+1] = bannerframeDisplay(240-60);
		t[#t+1] = bannerframeDisplay(240-120);
	end; 
	
end

--P1 StagePanel
if STATSMAN:GetStagesPlayed()==1 then
	t[#t+1] = StagePanelDisplay("PL1",240);
	-- t[#t+1] = 	LoadFont("CourseEntryDisplay","number") .. {
		-- InitCommand=cmd(x,320;y,240;shadowlength,1;zoomx,0.95;zoomy,0.7;strokecolor,color("0.2,0.2,0.2,1"));
		-- OnCommand=function(self, params) 
			-- self:settext(g1);
		-- end;
	-- }
elseif STATSMAN:GetStagesPlayed() == 2 then
	t[#t+1] = StagePanelDisplay("PL1",240+30);
	t[#t+1] = StagePanelDisplay("PL1",240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	t[#t+1] = StagePanelDisplay("PL1",240+60);
	t[#t+1] = StagePanelDisplay("PL1",240+0);
	t[#t+1] = StagePanelDisplay("PL1",240-60);
	
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StagePanelDisplay("PL1",240+60);
		t[#t+1] = StagePanelDisplay("PL1",240+0);
		t[#t+1] = StagePanelDisplay("PL1",240-60);
	else 
		t[#t+1] = StagePanelDisplay("PL1",240+90);
		t[#t+1] = StagePanelDisplay("PL1",240+30);
		t[#t+1] = StagePanelDisplay("PL1",240-30);
		t[#t+1] = StagePanelDisplay("PL1",240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StagePanelDisplay("PL1",240+60);
		t[#t+1] = StagePanelDisplay("PL1",240+0);
		t[#t+1] = StagePanelDisplay("PL1",240-60);
	elseif GAMESTATE:IsExtraStage()  then
		t[#t+1] = StagePanelDisplay("PL1",240+90);
		t[#t+1] = StagePanelDisplay("PL1",240+30);
		t[#t+1] = StagePanelDisplay("PL1",240-30);
		t[#t+1] = StagePanelDisplay("PL1",240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StagePanelDisplay("PL1",240+120);
		t[#t+1] = StagePanelDisplay("PL1",240+60);
		t[#t+1] = StagePanelDisplay("PL1",240+0);
		t[#t+1] = StagePanelDisplay("PL1",240-60);
		t[#t+1] = StagePanelDisplay("PL1",240-120);
	end; 
	
end

--P2 StagePanel
if STATSMAN:GetStagesPlayed()==1 then
	t[#t+1] = StagePanelDisplay("PL2",240);
	-- t[#t+1] = 	LoadFont("CourseEntryDisplay","number") .. {
		-- InitCommand=cmd(x,320;y,240;shadowlength,1;zoomx,0.95;zoomy,0.7;strokecolor,color("0.2,0.2,0.2,1"));
		-- OnCommand=function(self, params) 
			-- self:settext(g1);
		-- end;
	-- }
elseif STATSMAN:GetStagesPlayed() == 2 then
	t[#t+1] = StagePanelDisplay("PL2",240+30);
	t[#t+1] = StagePanelDisplay("PL2",240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	t[#t+1] = StagePanelDisplay("PL2",240+60);
	t[#t+1] = StagePanelDisplay("PL2",240+0);
	t[#t+1] = StagePanelDisplay("PL2",240-60);
	
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StagePanelDisplay("PL2",240+60);
		t[#t+1] = StagePanelDisplay("PL2",240+0);
		t[#t+1] = StagePanelDisplay("PL2",240-60);
	else 
		t[#t+1] = StagePanelDisplay("PL2",240+90);
		t[#t+1] = StagePanelDisplay("PL2",240+30);
		t[#t+1] = StagePanelDisplay("PL2",240-30);
		t[#t+1] = StagePanelDisplay("PL2",240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StagePanelDisplay("PL2",240+60);
		t[#t+1] = StagePanelDisplay("PL2",240+0);
		t[#t+1] = StagePanelDisplay("PL2",240-60);
	elseif GAMESTATE:IsExtraStage()  then
		t[#t+1] = StagePanelDisplay("PL2",240+90);
		t[#t+1] = StagePanelDisplay("PL2",240+30);
		t[#t+1] = StagePanelDisplay("PL2",240-30);
		t[#t+1] = StagePanelDisplay("PL2",240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StagePanelDisplay("PL2",240+120);
		t[#t+1] = StagePanelDisplay("PL2",240+60);
		t[#t+1] = StagePanelDisplay("PL2",240+0);
		t[#t+1] = StagePanelDisplay("PL2",240-60);
		t[#t+1] = StagePanelDisplay("PL2",240-120);
	end; 
	
end



---ScoreDisplay
local function StageScoreDisplay(pn, sScore, pos_Y)
	return LoadFont("_2helvetica-bold 24px") .. {
		InitCommand=cmd(y,pos_Y-5;shadowlength,1;zoomx,0.95;zoomy,0.7;zoomx,0.7;strokecolor,color("0.2,0.2,0.2,1"));
		OnCommand=function(self, params) 
			if(pn=="PL1") then
				self:x(SCREEN_CENTER_X-200);
				self:player('PlayerNumber_P1');
			else
				self:x(SCREEN_CENTER_X+200);
				self:player('PlayerNumber_P2');
			end
				local scorel3 = sScore%1000;
				local scorel2 = (sScore/1000)%1000;
				local scorel1 = (sScore/1000000)%1000000;
				self:settextf("%01d"..",".."%03d"..",".."%03d",scorel1,scorel2,scorel3);
		end;
		OffCommand=cmd(linear,0.1;diffusealpha,0);
	};
end




if STATSMAN:GetStagesPlayed()==1 then
	t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10);
elseif STATSMAN:GetStagesPlayed() == 2 then
	t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-30);
	t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+30);
elseif STATSMAN:GetStagesPlayed() == 3 then
	t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-60);
	t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+0);
	t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+60);
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-60);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+0);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+60);
	else 
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-90);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-30);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+30);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+90);
	end
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-60);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+0);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+60);
	elseif GAMESTATE:IsExtraStage()  then
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-90);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-30);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+30);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+90);
	elseif GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-120);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10-60);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+0);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+60);
		t[#t+1] = StageScoreDisplay("PL1",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetScore(),SCREEN_CENTER_Y+10+120);
	end;
end;

if STATSMAN:GetStagesPlayed()==1 then
	t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10);
elseif STATSMAN:GetStagesPlayed() == 2 then
	t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-30);
	t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+30);
elseif STATSMAN:GetStagesPlayed() == 3 then
	t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-60);
	t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+0);
	t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+60);
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-60);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+0);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+60);
	else 
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-90);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-30);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+30);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+90);
	end
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-60);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+0);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+60);
	elseif GAMESTATE:IsExtraStage()  then
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-90);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-30);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+30);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+90);
	elseif GAMESTATE:IsExtraStage2()  then
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-120);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10-60);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+0);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+60);
		t[#t+1] = StageScoreDisplay("PL2",STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetScore(),SCREEN_CENTER_Y+10+120);
	end;
end;

---DiffDisplay

local function StageDiffDisplay(pn, sdiff, pos_Y)
	return Def.ActorFrame {
		LoadActor(THEME:GetPathB("ScreenEvaluationSummary","Diff"))..{
		InitCommand=cmd(y,pos_Y+4;shadowlength,0;diffusealpha,0);
		OnCommand=function(self, params) 
			if(pn=="PL1") then
				self:x(SCREEN_CENTER_X-63.5);
				self:player('PlayerNumber_P1');
				self:diffuse(CustomDifficultyToColor(sdiff));
				(cmd(diffusealpha,0;sleep,0.1,linear,0.2;diffusealpha,1))(self);
			else
				self:x(SCREEN_CENTER_X+63.5);
				self:player('PlayerNumber_P2');
				self:diffuse(CustomDifficultyToColor(sdiff));
				(cmd(diffusealpha,0;sleep,0.1,linear,0.2;diffusealpha,1))(self);
				self:rotationy(180);
			end
		end;
		OffCommand=cmd(linear,0.2;diffusealpha,0;zoomy,0;);
		};
	};
end


if GAMESTATE:IsPlayerEnabled('PlayerNumber_P1') then

	if STATSMAN:GetStagesPlayed()==1 then
		local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
		t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y);
	elseif STATSMAN:GetStagesPlayed() == 2 then
		local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
		local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
		t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y-30);
		t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+30);
	elseif STATSMAN:GetStagesPlayed() == 3 then
		local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
		local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
		local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
		t[#t+1] = StageDiffDisplay("PL1",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
		t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
		t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
	elseif STATSMAN:GetStagesPlayed() == 4 then
		if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL1",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
			t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
			t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
		else 
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL1",diff4[1]:GetDifficulty(),SCREEN_CENTER_Y-90);
			t[#t+1] = StageDiffDisplay("PL1",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-30);
			t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+30);
			t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+90);
		end
	elseif STATSMAN:GetStagesPlayed() >= 5 then
		if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL1",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
			t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
			t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
		elseif GAMESTATE:IsExtraStage()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL1",diff4[1]:GetDifficulty(),SCREEN_CENTER_Y-90);
			t[#t+1] = StageDiffDisplay("PL1",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-30);
			t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+30);
			t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+90);
		elseif GAMESTATE:IsExtraStage2()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			local diff5 = STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P1'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL1",diff5[1]:GetDifficulty(),SCREEN_CENTER_Y-120);
			t[#t+1] = StageDiffDisplay("PL1",diff4[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
			t[#t+1] = StageDiffDisplay("PL1",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
			t[#t+1] = StageDiffDisplay("PL1",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
			t[#t+1] = StageDiffDisplay("PL1",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+120);
		end;
	end;
end;

if GAMESTATE:IsPlayerEnabled('PlayerNumber_P2') then

	if STATSMAN:GetStagesPlayed()==1 then
		local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
		t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y);
	elseif STATSMAN:GetStagesPlayed() == 2 then
		local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
		local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
		t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y-30);
		t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+30);
	elseif STATSMAN:GetStagesPlayed() == 3 then
		local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
		local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
		local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
		t[#t+1] = StageDiffDisplay("PL2",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
		t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
		t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
	elseif STATSMAN:GetStagesPlayed() == 4 then
		if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL2",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
			t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
			t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
		else 
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL2",diff4[1]:GetDifficulty(),SCREEN_CENTER_Y-90);
			t[#t+1] = StageDiffDisplay("PL2",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-30);
			t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+30);
			t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+90);
		end
	elseif STATSMAN:GetStagesPlayed() >= 5 then
		if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL2",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
			t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
			t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
		elseif GAMESTATE:IsExtraStage()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL2",diff4[1]:GetDifficulty(),SCREEN_CENTER_Y-90);
			t[#t+1] = StageDiffDisplay("PL2",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y-30);
			t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+30);
			t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+90);
		elseif GAMESTATE:IsExtraStage2()  then
			local diff1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			local diff5 = STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P2'):GetPlayedSteps();
			t[#t+1] = StageDiffDisplay("PL2",diff5[1]:GetDifficulty(),SCREEN_CENTER_Y-120);
			t[#t+1] = StageDiffDisplay("PL2",diff4[1]:GetDifficulty(),SCREEN_CENTER_Y-60);
			t[#t+1] = StageDiffDisplay("PL2",diff3[1]:GetDifficulty(),SCREEN_CENTER_Y+0);
			t[#t+1] = StageDiffDisplay("PL2",diff2[1]:GetDifficulty(),SCREEN_CENTER_Y+60);
			t[#t+1] = StageDiffDisplay("PL2",diff1[1]:GetDifficulty(),SCREEN_CENTER_Y+120);
		end;
	end;
end;






---P1 Award
if STATSMAN:GetStagesPlayed()==1 then
	local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
	t[#t+1] = finAwardDisplay("PL1", aw1, 240);
elseif STATSMAN:GetStagesPlayed() == 2 then
	local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
	local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
	t[#t+1] = finAwardDisplay("PL1", aw1, 240+30);
	t[#t+1] = finAwardDisplay("PL1", aw2, 240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
	local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
	local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
	t[#t+1] = finAwardDisplay("PL1", aw1, 240+60);
	t[#t+1] = finAwardDisplay("PL1", aw2, 240+0);
	t[#t+1] = finAwardDisplay("PL1", aw3, 240-60);
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL1", aw1, 240+60);
		t[#t+1] = finAwardDisplay("PL1", aw2, 240+0);
		t[#t+1] = finAwardDisplay("PL1", aw3, 240-60);
	else 
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL1", aw1, 240+90);
		t[#t+1] = finAwardDisplay("PL1", aw2, 240+30);
		t[#t+1] = finAwardDisplay("PL1", aw3, 240-30);
		t[#t+1] = finAwardDisplay("PL1", aw4, 240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL1", aw1, 240+60);
		t[#t+1] = finAwardDisplay("PL1", aw2, 240+0);
		t[#t+1] = finAwardDisplay("PL1", aw3, 240-60);
	elseif GAMESTATE:IsExtraStage()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL1", aw1, 240+90);
		t[#t+1] = finAwardDisplay("PL1", aw2, 240+30);
		t[#t+1] = finAwardDisplay("PL1", aw3, 240-30);
		t[#t+1] = finAwardDisplay("PL1", aw4, 240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		local aw5 = STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P1'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL1", aw1, 240+120);
		t[#t+1] = finAwardDisplay("PL1", aw2, 240+60);
		t[#t+1] = finAwardDisplay("PL1", aw3, 240+0);
		t[#t+1] = finAwardDisplay("PL1", aw4, 240-60);
		t[#t+1] = finAwardDisplay("PL1", aw5, 240-120);
	end; 
	
end

---P2 Award
if STATSMAN:GetStagesPlayed()==1 then
	local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
	t[#t+1] = finAwardDisplay("PL2", aw1, 240);
elseif STATSMAN:GetStagesPlayed() == 2 then
	local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
	local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
	t[#t+1] = finAwardDisplay("PL2", aw1, 240+30);
	t[#t+1] = finAwardDisplay("PL2", aw2, 240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
	local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
	local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
	t[#t+1] = finAwardDisplay("PL2", aw1, 240+60);
	t[#t+1] = finAwardDisplay("PL2", aw2, 240+0);
	t[#t+1] = finAwardDisplay("PL2", aw3, 240-60);
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL2", aw1, 240+60);
		t[#t+1] = finAwardDisplay("PL2", aw2, 240+0);
		t[#t+1] = finAwardDisplay("PL2", aw3, 240-60);
	else 
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL2", aw1, 240+90);
		t[#t+1] = finAwardDisplay("PL2", aw2, 240+30);
		t[#t+1] = finAwardDisplay("PL2", aw3, 240-30);
		t[#t+1] = finAwardDisplay("PL2", aw4, 240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL2", aw1, 240+60);
		t[#t+1] = finAwardDisplay("PL2", aw2, 240+0);
		t[#t+1] = finAwardDisplay("PL2", aw3, 240-60);
	elseif GAMESTATE:IsExtraStage()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL2", aw1, 240+90);
		t[#t+1] = finAwardDisplay("PL2", aw2, 240+30);
		t[#t+1] = finAwardDisplay("PL2", aw3, 240-30);
		t[#t+1] = finAwardDisplay("PL2", aw4, 240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		local aw1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		local aw5 = STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P2'):GetStageAward();
		t[#t+1] = finAwardDisplay("PL2", aw1, 240+120);
		t[#t+1] = finAwardDisplay("PL2", aw2, 240+60);
		t[#t+1] = finAwardDisplay("PL2", aw3, 240+0);
		t[#t+1] = finAwardDisplay("PL2", aw4, 240-60);
		t[#t+1] = finAwardDisplay("PL2", aw5, 240-120);
	end; 
	
end








---P1 Grade
if STATSMAN:GetStagesPlayed()==1 then
	local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
	t[#t+1] = finGradeDisplay("PL1", g1, 240);
	-- t[#t+1] = 	LoadFont("CourseEntryDisplay","number") .. {
		-- InitCommand=cmd(x,320;y,240;shadowlength,1;zoomx,0.95;zoomy,0.7;strokecolor,color("0.2,0.2,0.2,1"));
		-- OnCommand=function(self, params) 
			-- self:settext(g1);
		-- end;
	-- }
elseif STATSMAN:GetStagesPlayed() == 2 then
	local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
	local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
	t[#t+1] = finGradeDisplay("PL1", g1, 240+30);
	t[#t+1] = finGradeDisplay("PL1", g2, 240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
	local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
	local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
	t[#t+1] = finGradeDisplay("PL1", g1, 240+60);
	t[#t+1] = finGradeDisplay("PL1", g2, 240+0);
	t[#t+1] = finGradeDisplay("PL1", g3, 240-60);
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		t[#t+1] = finGradeDisplay("PL1", g1, 240+60);
		t[#t+1] = finGradeDisplay("PL1", g2, 240+0);
		t[#t+1] = finGradeDisplay("PL1", g3, 240-60);
	else 
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		t[#t+1] = finGradeDisplay("PL1", g1, 240+90);
		t[#t+1] = finGradeDisplay("PL1", g2, 240+30);
		t[#t+1] = finGradeDisplay("PL1", g3, 240-30);
		t[#t+1] = finGradeDisplay("PL1", g4, 240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		t[#t+1] = finGradeDisplay("PL1", g1, 240+60);
		t[#t+1] = finGradeDisplay("PL1", g2, 240+0);
		t[#t+1] = finGradeDisplay("PL1", g3, 240-60);
	elseif GAMESTATE:IsExtraStage()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		t[#t+1] = finGradeDisplay("PL1", g1, 240+90);
		t[#t+1] = finGradeDisplay("PL1", g2, 240+30);
		t[#t+1] = finGradeDisplay("PL1", g3, 240-30);
		t[#t+1] = finGradeDisplay("PL1", g4, 240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		local g5 = STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P1'):GetGrade();
		t[#t+1] = finGradeDisplay("PL1", g1, 240+120);
		t[#t+1] = finGradeDisplay("PL1", g2, 240+60);
		t[#t+1] = finGradeDisplay("PL1", g3, 240+0);
		t[#t+1] = finGradeDisplay("PL1", g4, 240-60);
		t[#t+1] = finGradeDisplay("PL1", g5, 240-120);
	end; 
	
end

---P2 Grade
if STATSMAN:GetStagesPlayed()==1 then
	local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
	t[#t+1] = finGradeDisplay("PL2", g1, 240);
	-- t[#t+1] = 	LoadFont("CourseEntryDisplay","number") .. {
		-- InitCommand=cmd(x,320;y,240;shadowlength,1;zoomx,0.95;zoomy,0.7;strokecolor,color("0.2,0.2,0.2,1"));
		-- OnCommand=function(self, params) 
			-- self:settext(g1);
		-- end;
	-- }
elseif STATSMAN:GetStagesPlayed() == 2 then
	local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
	local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
	t[#t+1] = finGradeDisplay("PL2", g1, 240+30);
	t[#t+1] = finGradeDisplay("PL2", g2, 240-30);
	
elseif STATSMAN:GetStagesPlayed() == 3 then
	local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
	local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
	local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
	t[#t+1] = finGradeDisplay("PL2", g1, 240+60);
	t[#t+1] = finGradeDisplay("PL2", g2, 240+0);
	t[#t+1] = finGradeDisplay("PL2", g3, 240-60);
elseif STATSMAN:GetStagesPlayed() == 4 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		t[#t+1] = finGradeDisplay("PL2", g1, 240+60);
		t[#t+1] = finGradeDisplay("PL2", g2, 240+0);
		t[#t+1] = finGradeDisplay("PL2", g3, 240-60);
	else 
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		t[#t+1] = finGradeDisplay("PL2", g1, 240+90);
		t[#t+1] = finGradeDisplay("PL2", g2, 240+30);
		t[#t+1] = finGradeDisplay("PL2", g3, 240-30);
		t[#t+1] = finGradeDisplay("PL2", g4, 240-90);
	end; 
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if not GAMESTATE:IsExtraStage() and not GAMESTATE:IsExtraStage2()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		t[#t+1] = finGradeDisplay("PL2", g1, 240+60);
		t[#t+1] = finGradeDisplay("PL2", g2, 240+0);
		t[#t+1] = finGradeDisplay("PL2", g3, 240-60);
	elseif GAMESTATE:IsExtraStage()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		t[#t+1] = finGradeDisplay("PL2", g1, 240+90);
		t[#t+1] = finGradeDisplay("PL2", g2, 240+30);
		t[#t+1] = finGradeDisplay("PL2", g3, 240-30);
		t[#t+1] = finGradeDisplay("PL2", g4, 240-90);
	elseif GAMESTATE:IsExtraStage2()  then
		local g1 = STATSMAN:GetPlayedStageStats(1):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g2 = STATSMAN:GetPlayedStageStats(2):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g3 = STATSMAN:GetPlayedStageStats(3):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g4 = STATSMAN:GetPlayedStageStats(4):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		local g5 = STATSMAN:GetPlayedStageStats(5):GetPlayerStageStats('PlayerNumber_P2'):GetGrade();
		t[#t+1] = finGradeDisplay("PL2", g1, 240+120);
		t[#t+1] = finGradeDisplay("PL2", g2, 240+60);
		t[#t+1] = finGradeDisplay("PL2", g3, 240+0);
		t[#t+1] = finGradeDisplay("PL2", g4, 240-60);
		t[#t+1] = finGradeDisplay("PL2", g5, 240-120);
	end; 
	
end


--stager
function stageDisplay(pn, sStage, pos_Y)
	return Def.Sprite{
		InitCommand = function(self)
			if(sStage == '1st') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","1st"));
			elseif(sStage == '2nd') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","2nd"));
			elseif(sStage == '3rd') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","3rd"));
			elseif(sStage == '4th') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","4th"));
			elseif(sStage == '5th') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","5th"));
			elseif(sStage == '6th') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","6th"));
			elseif(sStage == 'Final') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","Final"));
			elseif(sStage == 'Extra1') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","Extra1"));
			elseif(sStage == 'Extra2') then
				self:Load(THEME:GetPathB("SummaryStageDisplay","Extra2"));
			end;
			
			if(pn=="PL1") then
				self:player('PlayerNumber_P1');
				self:x(SCREEN_CENTER_X-180);
			else
				self:player('PlayerNumber_P2');
				self:x(SCREEN_CENTER_X+180);
			end
			
			self:y(pos_Y-10);
			self:zoomy(0);
			self:diffusealpha(0);
		end;
		OnCommand=cmd(sleep,0.1;linear,0.2;zoomy,1;diffusealpha,1);
		OffCommand=cmd(linear,0.2;zoomy,0;diffusealpha,0);

	}
end

if STATSMAN:GetStagesPlayed()==1 then
	t[#t+1] = stageDisplay("PL1", 'Final', 240);
	t[#t+1] = stageDisplay("PL2", 'Final', 240);
elseif STATSMAN:GetStagesPlayed() == 2 then
	if(GAMESTATE:IsExtraStage()) then
		t[#t+1] = stageDisplay("PL1", 'Final',  240-30);
		t[#t+1] = stageDisplay("PL1", 'Extra1', 240+30);
		t[#t+1] = stageDisplay("PL2", 'Final',  240-30);
		t[#t+1] = stageDisplay("PL2", 'Extra1', 240+30);
	else
		t[#t+1] = stageDisplay("PL1", '1st',   240-30);
		t[#t+1] = stageDisplay("PL1", 'Final', 240+30);
		t[#t+1] = stageDisplay("PL2", '1st',   240-30);
		t[#t+1] = stageDisplay("PL2", 'Final', 240+30);
	end;
elseif STATSMAN:GetStagesPlayed() == 3 then
	if(GAMESTATE:IsExtraStage2()) then
		t[#t+1] = stageDisplay("PL1", 'Final',  240-60);
		t[#t+1] = stageDisplay("PL1", 'Extra1', 240+0);
		t[#t+1] = stageDisplay("PL1", 'Extra2', 240+60);
		t[#t+1] = stageDisplay("PL2", 'Final',  240-60);
		t[#t+1] = stageDisplay("PL2", 'Extra1', 240+0);
		t[#t+1] = stageDisplay("PL2", 'Extra2', 240+60);
	elseif (GAMESTATE:IsExtraStage()) then
		t[#t+1] = stageDisplay("PL1", '1st',    240-60);
		t[#t+1] = stageDisplay("PL1", 'Final',  240+0);
		t[#t+1] = stageDisplay("PL1", 'Extra1', 240+60);
		t[#t+1] = stageDisplay("PL2", '1st',  240-60);
		t[#t+1] = stageDisplay("PL2", 'Final', 240+0);
		t[#t+1] = stageDisplay("PL2", 'Extra1', 240+60);
	else
		t[#t+1] = stageDisplay("PL1", '1st',   240-60);
		t[#t+1] = stageDisplay("PL1", '2nd',   240+0);
		t[#t+1] = stageDisplay("PL1", 'Final', 240+60);
		t[#t+1] = stageDisplay("PL2", '1st',   240-60);
		t[#t+1] = stageDisplay("PL2", '2nd',   240+0);
		t[#t+1] = stageDisplay("PL2", 'Final', 240+60);
	end;
elseif STATSMAN:GetStagesPlayed() == 4 then
	if(GAMESTATE:IsExtraStage2()) then
		t[#t+1] = stageDisplay("PL1", '1st',     240-90);
		t[#t+1] = stageDisplay("PL1", 'Final',   240-30);
		t[#t+1] = stageDisplay("PL1", 'Extra1',  240+30);
		t[#t+1] = stageDisplay("PL1", 'Extra2',  240+90);
		t[#t+1] = stageDisplay("PL2", '1st',     240-90);
		t[#t+1] = stageDisplay("PL2", 'Final',   240-30);
		t[#t+1] = stageDisplay("PL2", 'Extra1',  240+30);
		t[#t+1] = stageDisplay("PL2", 'Extra2',  240+90);
	elseif (GAMESTATE:IsExtraStage()) then
		t[#t+1] = stageDisplay("PL1", '1st',     240-90);
		t[#t+1] = stageDisplay("PL1", '2nd',     240-30);
		t[#t+1] = stageDisplay("PL1", 'Final',   240+30);
		t[#t+1] = stageDisplay("PL1", 'Extra1',  240+90);
		t[#t+1] = stageDisplay("PL2", '1st',     240-90);
		t[#t+1] = stageDisplay("PL2", '2nd',     240-30);
		t[#t+1] = stageDisplay("PL2", 'Final',   240+30);
		t[#t+1] = stageDisplay("PL2", 'Extra1',  240+90);
	else
		t[#t+1] = stageDisplay("PL1", '2nd',   240-60);
		t[#t+1] = stageDisplay("PL1", '3rd',   240+0);
		t[#t+1] = stageDisplay("PL1", 'Final', 240+60);
		t[#t+1] = stageDisplay("PL2", '2nd',   240-60);
		t[#t+1] = stageDisplay("PL2", '3rd',   240+0);
		t[#t+1] = stageDisplay("PL2", 'Final', 240+60);
	end
elseif STATSMAN:GetStagesPlayed() >= 5 then
	if(GAMESTATE:IsExtraStage2()) then
		t[#t+1] = stageDisplay("PL1", '1st',     240-120);
		t[#t+1] = stageDisplay("PL1", '2nd',     240-60);
		t[#t+1] = stageDisplay("PL1", 'Final',   240+0);
		t[#t+1] = stageDisplay("PL1", 'Extra1',  240+60);
		t[#t+1] = stageDisplay("PL1", 'Extra2',  240+120);
		t[#t+1] = stageDisplay("PL2", '1st',     240-120);
		t[#t+1] = stageDisplay("PL2", '2nd',     240-60);
		t[#t+1] = stageDisplay("PL2", 'Final',   240+0);
		t[#t+1] = stageDisplay("PL2", 'Extra1',  240+60);
		t[#t+1] = stageDisplay("PL2", 'Extra2',  240+120);
	elseif (GAMESTATE:IsExtraStage()) then
		t[#t+1] = stageDisplay("PL1", '2nd',     240-90);
		t[#t+1] = stageDisplay("PL1", '3rd',     240-30);
		t[#t+1] = stageDisplay("PL1", 'Final',   240+30);
		t[#t+1] = stageDisplay("PL1", 'Extra1',  240+90);
		t[#t+1] = stageDisplay("PL2", '2nd',     240-90);
		t[#t+1] = stageDisplay("PL2", '3rd',     240-30);
		t[#t+1] = stageDisplay("PL2", 'Final',   240+30);
		t[#t+1] = stageDisplay("PL2", 'Extra1',  240+90);
	else
		t[#t+1] = stageDisplay("PL1", '3rd',   240-60);
		t[#t+1] = stageDisplay("PL1", '4th',   240+0);
		t[#t+1] = stageDisplay("PL1", 'Final', 240+60);
		t[#t+1] = stageDisplay("PL2", '3rd',   240-60);
		t[#t+1] = stageDisplay("PL2", '4th',   240+0);
		t[#t+1] = stageDisplay("PL2", 'Final', 240+60);
	end
end









---song Info function---
function SongDisplay(song, pos_Y)
	return Def.ActorFrame {
		
		
		Def.Quad {
			InitCommand=cmd(diffusealpha,0;x,SCREEN_CENTER_X;y,pos_Y-30;zoomto,SCREEN_WIDTH+30,1;fadeleft,0.25;faderight,0.25;);
			OnCommand=cmd(sleep,0.1;linear,0.2;diffuse,Color("Black");diffusealpha,0.13);
			OffCommand=cmd(linear,0.2;zoomy,0;diffusealpha,0);
		};
		
		Def.Quad {
			InitCommand=cmd(diffusealpha,0;x,SCREEN_CENTER_X;y,pos_Y+30;zoomto,SCREEN_WIDTH+30,1;fadeleft,0.25;faderight,0.25;);
			OnCommand=cmd(sleep,0.1;linear,0.2;diffuse,Color("Black");diffusealpha,0.13);
			OffCommand=cmd(linear,0.2;zoomy,0;diffusealpha,0);
		};
		
		Def.Sprite{
			InitCommand = function(self)
				self:Load(GetSongGPath(song));
				self:x(SCREEN_CENTER_X-80);
				
				self:y(pos_Y);
				self:zoom(0);
				self:diffusealpha(0);
			end;
			OnCommand=cmd(sleep,0.1;linear,0.2;scaletoclipped,50,50;diffusealpha,1);
			OffCommand=cmd(linear,0.2;zoom,0;diffusealpha,0);
		};

	};
end

---Load song Info---
if STATSMAN:GetStagesPlayed()==1 then
	local songs = STATSMAN:GetPlayedStageStats(1):GetPlayedSongs();
	
	t[#t+1] = SongDisplay(songs[1],240);
elseif STATSMAN:GetStagesPlayed()==2 then
	local songs1 = STATSMAN:GetPlayedStageStats(1):GetPlayedSongs();
	local songs2 = STATSMAN:GetPlayedStageStats(2):GetPlayedSongs();
	t[#t+1] = SongDisplay(songs2[1],240-30);
	t[#t+1] = SongDisplay(songs1[1],240+30);
elseif STATSMAN:GetStagesPlayed()==3 then
	local songs1 = STATSMAN:GetPlayedStageStats(1):GetPlayedSongs();
	local songs2 = STATSMAN:GetPlayedStageStats(2):GetPlayedSongs();
	local songs3 = STATSMAN:GetPlayedStageStats(3):GetPlayedSongs();
	t[#t+1] = SongDisplay(songs3[1],240-60);
	t[#t+1] = SongDisplay(songs2[1],240+0);
	t[#t+1] = SongDisplay(songs1[1],240+60);
elseif STATSMAN:GetStagesPlayed()==4 then
	local songs1 = STATSMAN:GetPlayedStageStats(1):GetPlayedSongs();
	local songs2 = STATSMAN:GetPlayedStageStats(2):GetPlayedSongs();
	local songs3 = STATSMAN:GetPlayedStageStats(3):GetPlayedSongs();
	local songs4 = STATSMAN:GetPlayedStageStats(4):GetPlayedSongs();
	if(GAMESTATE:IsExtraStage2()) then
		t[#t+1] = SongDisplay(songs4[1],240-90);
		t[#t+1] = SongDisplay(songs3[1],240-30);
		t[#t+1] = SongDisplay(songs2[1],240+30);
		t[#t+1] = SongDisplay(songs1[1],240+90);
	elseif (GAMESTATE:IsExtraStage()) then
		t[#t+1] = SongDisplay(songs4[1],240-90);
		t[#t+1] = SongDisplay(songs3[1],240-30);
		t[#t+1] = SongDisplay(songs2[1],240+30);
		t[#t+1] = SongDisplay(songs1[1],240+90);
	else 
		t[#t+1] = SongDisplay(songs3[1],240-60);
		t[#t+1] = SongDisplay(songs2[1],240+0);
		t[#t+1] = SongDisplay(songs1[1],240+60);
	end
elseif STATSMAN:GetStagesPlayed()>=5 then
	local songs1 = STATSMAN:GetPlayedStageStats(1):GetPlayedSongs();
	local songs2 = STATSMAN:GetPlayedStageStats(2):GetPlayedSongs();
	local songs3 = STATSMAN:GetPlayedStageStats(3):GetPlayedSongs();
	local songs4 = STATSMAN:GetPlayedStageStats(4):GetPlayedSongs();
	local songs5 = STATSMAN:GetPlayedStageStats(5):GetPlayedSongs();
	if(GAMESTATE:IsExtraStage2()) then
		t[#t+1] = SongDisplay(songs5[1],240-120);
		t[#t+1] = SongDisplay(songs4[1],240-60);
		t[#t+1] = SongDisplay(songs3[1],240+0);
		t[#t+1] = SongDisplay(songs2[1],240+60);
		t[#t+1] = SongDisplay(songs1[1],240+120);
	elseif (GAMESTATE:IsExtraStage()) then
		t[#t+1] = SongDisplay(songs4[1],240-90);
		t[#t+1] = SongDisplay(songs3[1],240-30);
		t[#t+1] = SongDisplay(songs2[1],240+30);
		t[#t+1] = SongDisplay(songs1[1],240+90);
	else 
		t[#t+1] = SongDisplay(songs3[1],240-60);
		t[#t+1] = SongDisplay(songs2[1],240+0);
		t[#t+1] = SongDisplay(songs1[1],240+60);
	end
end


t[#t+1] = Def.Sprite{
	InitCommand = function(self)
		self:player('PlayerNumber_P1');
		self:x(SCREEN_CENTER_X-247.2);
		self:Load(THEME:GetPathB("SummaryPlayerDisplay","P1"));
		self:y(112);
	end;
	OnCommand=cmd(zoomy,0;diffusealpha,0;sleep,0.1,linear,0.2;zoomy,1;diffusealpha,1);
	OffCommand=cmd(linear,0.25;diffusealpha,0;zoomy,0);
}



-----PlayerDisplay
t[#t+1] = Def.Sprite{
	InitCommand = function(self)
		self:player('PlayerNumber_P2');
		self:x(SCREEN_CENTER_X+247.2);
		self:Load(THEME:GetPathB("SummaryPlayerDisplay","P2"));
		self:y(112);
	end;
	OnCommand=cmd(zoomy,0;diffusealpha,0;sleep,0.1,linear,0.2;zoomy,1;diffusealpha,1);
	OffCommand=cmd(linear,0.25;diffusealpha,0;zoomy,0);
}


return t ;




